'use client';
import { useState, useEffect } from 'react';
import Link from 'next/link';
import { FaChrome, FaFirefox, FaSafari, FaEdge, FaInternetExplorer } from 'react-icons/fa';
import { useSelector } from 'react-redux';
import Sidebar from '@/app/Components/Home/Sidebar';
import Header from '@/app/Components/Home/Header';
import ChatVisitor from './ChatVisitor';
import { FaWindows,  FaApple } from "react-icons/fa";
import { getCookie } from 'cookies-next';
import { getSocket } from '@/app/lib/socketManager';
import { useParams } from 'next/navigation';
import { countryNameToCode } from '@/app/countries';
import { IoLogoApple } from "react-icons/io5";
import notificationSound from '@/public/sounds/chatalert.mp3';
import { decryptData } from '@/app/utils/DecryptData';
const Chat = () => {
  const [showToast, setShowToast] = useState(false);
  const [socket, setSocket] = useState(null);
  const [messages, setMessages] = useState([]);
  const [newMessage, setNewMessage] = useState('');
  const [currentChat, setCurrentChat] = useState(null);
  const [visitors, setVisitors] = useState([]);
  const [hideColumns, setHideColumns] = useState(false);
  const [blinkingVisitor, setBlinkingVisitor] = useState([]);
  // New state to track which row should blink

  const status = useSelector((state) => state.user.status);
  const user = useSelector((state) => state.user.userInfo);
  const { bid } = useParams();
  const brand_pk =  sessionStorage.getItem('brand_public_key')
 
  const [originalJoinTimes, setOriginalJoinTimes] = useState({});
  const token = getCookie('token');
  function emitTimeInUserTimezone(serverTime) {
    // Parse the server time (ISO format in UTC)
    const serverUtcTime = new Date(serverTime); // ISO string will be handled as UTC automatically

    // Get the user's local time zone (e.g., 'Asia/Karachi')
    const userTimezone = Intl.DateTimeFormat().resolvedOptions().timeZone;

    // Format the server time into the user's local time zone
    const userLocalTime = new Intl.DateTimeFormat('en-US', {
        timeZone: userTimezone,
        year: 'numeric',
        month: '2-digit',
        day: '2-digit',
        hour: '2-digit',
        minute: '2-digit',
        second: '2-digit',
        hour12: true // Change to false for 24-hour format if desired
    }).format(serverUtcTime);

    // Emit or log the converted time
    
    return userLocalTime;
}

 //if currentchat.clientid != recievedchat.clientid ? 'make sound alert':'no action'
 //client send message > chat is not opened > it's not seen > make sound
 //client send message > ...............> show blinking
 //..................  > chat is seen and then closed > don't show blinking
 const removeBlinkingVisitor = (clientId) => {
   
  setBlinkingVisitor((prevBlinkingVisitors) => {
    // Filter out the specific clientId
    return prevBlinkingVisitors.filter((id) => id !== clientId);
  });
};


useEffect(() => {
 
}, [])



  useEffect(() => {
   
    // Ensure socket instance is created once
    const socketinst = getSocket();
    if (!socketinst) return;

    setSocket(socketinst);
 
// Emit brand ID to the backend when the page loads
socketinst.emit('page load', { brand_id: bid });

const handleActiveVisitors = (data) => {
  const decryptedData = decryptData(data)
  const { client_id, public_key, join_time,unseenMsg, served_by, landing_url, os, ip, country, status, visitor_session_id, client_name ,browser } = decryptedData;

 const j_time= emitTimeInUserTimezone(join_time);
  // Save the original join_time with client_id
  setOriginalJoinTimes(prevTimes => ({
    ...prevTimes,
    [client_id]: join_time // Store the original join time for this client_id
  }));

  const joinDate = new Date(j_time);
  const formattedJoinTime = joinDate.toLocaleTimeString('en-US', { hour: 'numeric', minute: 'numeric', hour12: true });

  const newVisitor = {
    name: client_name ? client_name : `Visitor ${client_id}`,
    client_id: client_id,
    online: joinDate,
    servedBy: served_by,
    viewing: landing_url,
    link: "https://example.com",
    public_key: public_key,
    join_time: formattedJoinTime, // Use formatted join time
    visitorStatus: status,
    visitor_session_id: visitor_session_id,
    os: os,
    ip: ip,
    country: country,
    browser: browser,
    unseenMsg: unseenMsg,
  };

  setVisitors(prevVisitors => {
    // Check if the visitor with the same client_id already exists
    const existingVisitorIndex = prevVisitors.findIndex(v => v.client_id === client_id);

    if (existingVisitorIndex > -1) {
      // Update existing visitor
      const updatedVisitors = [...prevVisitors];
      updatedVisitors[existingVisitorIndex] = newVisitor;
      return updatedVisitors;
    } else {
      // Add new visitor only if it doesn't already exist
      return [...prevVisitors, newVisitor];
    }
  });
};

const handleNewClient = (data) => {
  const decryptedData = decryptData(data)

  const { client_id, public_key, join_time, landing_url, os, ip, country, status, browser } = decryptedData;
  if(brand_pk != public_key){
    return null;
  }
  emitTimeInUserTimezone(join_time);
  
  // Save the original join_time with client_id
  setOriginalJoinTimes((prevTimes) => ({
    ...prevTimes,
    [client_id]: join_time, // Store the original join time
  }));

  const joinDate = new Date(join_time);
  const formattedJoinTime = joinDate.toLocaleTimeString('en-US', { hour: 'numeric', minute: 'numeric', hour12: true });
  
  const newVisitor = {
    name: `Visitor ${client_id}`,
    client_id: client_id,
    online: joinDate,
    servedBy: "",
    viewing: landing_url,
    link: "https://example.com",
    public_key: public_key,
    join_time: formattedJoinTime,
    visitorStatus: status,
    visitor_session_id: data.visitor_session_id,
    os: os,
    ip: ip,
    country: country,
    browser: browser,
  };

  // Log the visitors before the update
  

  // Update the state with the new visitor
  setVisitors((prevVisitors) => {
    const updatedVisitors = [newVisitor, ...prevVisitors];
     // Log inside setState to ensure proper order
    return updatedVisitors;
  });
};

    const handleVisitorServedByUpdate = (data) => {
      const decryptedData = decryptData(data)
      const { client_id, served_by } = decryptedData;
      
      
      
      setVisitors(prevVisitors => {
        return prevVisitors.map(visitor =>
          visitor.client_id === client_id
            ? { ...visitor, servedBy: served_by }
            : visitor
        );
      });
      
    };

    const handleVisitorStatusChange = (data) => {
      const decryptedData = decryptData(data)
      const { client_id, status } = decryptedData
      
      setVisitors(prevVisitors => {
        if (status === 4) {
          
          
          if(currentChat?.client_id == client_id ){
            setHideColumns(false);
            setCurrentChat(null);

          }
          return prevVisitors.filter(visitor => visitor.client_id !== client_id);
        } else {
          // Update visitor's status in the list
          const updatedVisitors = prevVisitors.map(visitor =>
            visitor.client_id === client_id ? { ...visitor, visitorStatus: status } : visitor
          );
    
          // If the current chat's visitor's status is updated, also update the currentChat state
          if (currentChat?.client_id === client_id) {
            setCurrentChat(prevChat => ({ ...prevChat, visitorStatus: status }));
          }
    
          return updatedVisitors;
        }
      });
    };
    const playNotificationSound = () => {
      // const audio = new Audio(notificationSound);
      // audio.play().catch(err => console.error('Error playing sound:', err));
    };
    
    
    const handleNewMessageBlink = (data) => {
      const decryptedData = decryptData(data)
      const message = decryptedData;
       
       
      // if(message.public_key != brand_pk){
      //   return null;
      // }
      if(message.isParticipant){
        // playNotificationSound();
      }
      // Only add to blinking state if the current chat is NOT the one receiving the message
      if (currentChat?.client_id !== message.client_id) {
        setVisitors(prevVisitors => {
          return prevVisitors.map(visitor =>
            visitor.client_id === message.client_id
              ? { ...visitor, unseenMsg: message.unseenCount }
              : visitor
          );
        });
        setBlinkingVisitor(prevBlinkingVisitors => {
          if (!prevBlinkingVisitors.includes(message.client_id)) {
            return [...prevBlinkingVisitors, message.client_id];
          }
          return prevBlinkingVisitors;
        });
      } else {
        // If current chat is the same as the message client, we can remove blinking
        removeBlinkingVisitor(message.client_id);
      }
    };
      const handleMessageSeen = (data) => {
        const decryptedData = decryptData(data)
         const message = decryptedData;
         
        setVisitors((prevVisitors) =>
          prevVisitors.map((visitor) =>
            visitor.client_id === message.client_id
              ? { ...visitor, unseenMsg: 0 }
              : visitor
          )
        );
      
      }
    
    const handleChatMessage = (data) => {
      const decryptedData = decryptData(data)
       const message = decryptedData;
       
      if (message.client_id !== currentChat?.client_id) {
        
        
        // Play sound
        // const audio = new Audio(notificationSound); // Adjust the path if necessary
        // audio.play().catch(err => {
        //   console.error("Error playing sound:", err);
        // });
    
        // Update messages state
        setMessages(prevMessages => [...prevMessages, message]);
      }
    };
    
    // Attach event listeners
    socketinst.on('active visitors', handleActiveVisitors);
    socketinst.on('new client', handleNewClient);
    socketinst.on('visitor served by update', handleVisitorServedByUpdate);
    socketinst.on('visitor status change', handleVisitorStatusChange);
    socketinst.on('chat message', handleChatMessage);
    socketinst.on('New message blink', handleNewMessageBlink);
    socketinst.on('message_seen', handleMessageSeen);

    return () => {
      // Clean up event listeners
      socketinst.off('active visitors', handleActiveVisitors);
      socketinst.off('new client', handleNewClient);
      socketinst.off('visitor served by update', handleVisitorServedByUpdate);
      socketinst.off('visitor status change', handleVisitorStatusChange);
      socketinst.off('New message blink', handleNewMessageBlink);
      socketinst.off('chat message', handleChatMessage);
      socketinst.off('message_seen', handleMessageSeen);
      // socketinst.off('chat message', handleChatMessage);
    };
  }, [bid, currentChat]);

  const handleVisitorClick = (visitor) => {
    if (currentChat && currentChat.client_id === visitor.client_id) {
      setHideColumns(false);
      socket.emit('admin_closed_chat',{
        client_id: visitor.client_id,
        public_key: visitor.public_key,
        pseudonym: user.pseudonym,
        user_id: user.userId

      })
      setCurrentChat(null);
    } else {
      if (currentChat) {
        setHideColumns(false);
      }
      const updatedVisitor = {
        ...visitor,
        pseudonym: user.pseudonym,
        userId: user.userId
      };
      
      setCurrentChat(updatedVisitor);
      socket.emit('join chat', updatedVisitor);
      // removeBlinkingVisitor(visitor.client_id);
      // new event ' is chat seen' will create  with data = 
      //client_id ,public_key, isSeen:true/false , chat session_id , may be message_id,
      //when chat is already open or when user open it or see the message emit is chat seen as true in backend then backend will send it to all admin or all room users
      //then is visitors state will update messageSeen:true, default false
      //if not served make sound to everyone who assigned to that brand
      //if served fetch admins which are joined to that chat and make sound

      setHideColumns(true);
    }
  }; 

  const handleVisitorNameClick = () => {
    setHideColumns(!hideColumns);
  };

  const copyChatId = (e) => {
    const chatIdElement = e.target.closest('button').previousElementSibling;
    if (chatIdElement) {
      const chatId = chatIdElement.textContent;
  
      // Attempt to copy using the Clipboard API
      navigator.clipboard.writeText(chatId)
        .then(() => {
          setShowToast(true);
          setTimeout(() => setShowToast(false), 2000);
        })
        .catch(err => {
          console.error('Failed to copy using Clipboard API:', err);
  
          // Fallback method using a temporary textarea
          const tempTextArea = document.createElement('textarea');
          tempTextArea.value = chatId;
          document.body.appendChild(tempTextArea);
          tempTextArea.select();
  
          try {
            const successful = document.execCommand('copy');
            if (successful) {
              setShowToast(true);
              setTimeout(() => setShowToast(false), 2000);
            } else {
              alert('Copy failed. Please try manually.');
            }
          } catch (fallbackErr) {
            console.error('Fallback copy method failed:', fallbackErr);
            alert('Failed to copy text to clipboard.');
          } finally {
            document.body.removeChild(tempTextArea); // Clean up
          }
        });
    } else {
      console.error('Chat ID element not found');
    }
  };
  

  const categorizedVisitors = {
    active: visitors.filter(v => v.visitorStatus === 1 || v.visitorStatus === 5),
    idle: visitors.filter(v => v.visitorStatus === 2),
    closed: visitors.filter(v => v.visitorStatus === 3),
  };



  if (status !== "succeeded") {
    // return <>Loading...</>;
  }

  return (
    <>
   
        {showToast && (
          <div className="toast show" role="alert" aria-live="assertive" aria-atomic="true">
            <div className="toast-header">
              <strong className="mr-auto">Copied</strong>
              <button type="button" className="ml-2 mb-1 close" data-bs-dismiss="toast" aria-label="Close">
                <span aria-hidden="true">&times;</span>
              </button>
            </div>
            <div className="toast-body">Chat ID copied to clipboard!</div>
          </div>
        )}
     
        <div className="container-fluid top-bar">
          <div className="left-div">
            <h2>Visitors</h2>
          </div>
          <div className="right-div"></div>
        </div>
         <div className="chat-visitor-container">
          <div className={`chat-main-content ${hideColumns ? 'half-width' : ''}`}>
            <h3>Currently Active Visitors</h3>
            <VisitorTable visitors={categorizedVisitors.active} copyChatId={copyChatId} onVisitorNameClick={handleVisitorClick} hideColumns={hideColumns}   blinkingVisitor= {blinkingVisitor} />
            {categorizedVisitors.idle.length > 0 && (
    <>
      <h3 className="mt-3">Idle Visitors</h3>
      <VisitorTable 
        visitors={categorizedVisitors.idle} 
        copyChatId={copyChatId} 
        onVisitorNameClick={handleVisitorClick} 
        hideColumns={hideColumns} 
        blinkingVisitor= {blinkingVisitor}
      />
    </>
  )}

  {categorizedVisitors.closed.length > 0 && (
    <>
      <h3 className="mt-3">Closed Chats</h3>
      <VisitorTable 
        visitors={categorizedVisitors.closed} 
        copyChatId={copyChatId} 
        onVisitorNameClick={handleVisitorClick} 
        hideColumns={hideColumns} 
        blinkingVisitor= {blinkingVisitor}
      />
    </>
  )}
          </div>

          {hideColumns && <ChatVisitor currentChat={currentChat} setHideColumns={setHideColumns}  setCurrentChat={setCurrentChat} originalJoinTimes={originalJoinTimes} />}
        </div>
       
     
    </>
  );
};

const VisitorTable = ({ visitors, copyChatId, onVisitorNameClick, hideColumns ,blinkingVisitor}) => (
  <table className="chat-stats-table">
 
    <thead>
      <tr>
        <th></th>
        <th>Visitor</th>
        <th></th>
        <th className={hideColumns ? 'd-none' : ''}>Online</th>
        <th className={hideColumns ? 'd-none' : ''}>Served by</th>
        <th className={hideColumns ? 'd-none' : ''}>Landed</th>
      </tr>
    </thead>
    <tbody>
      {visitors.map((visitor, index) => (
        <VisitorRow 
          key={index}
          name={visitor.name}
          chatId={visitor.client_id}
          visitorStatus={visitor.visitorStatus}
          visitor={visitor}
          online={visitor.online}
          servedBy={visitor.servedBy}
          unseenMsg ={visitor.unseenMsg}
          viewing={visitor.viewing}
          link={visitor.link}
          copyChatId={copyChatId}
          onVisitorNameClick={onVisitorNameClick}
          hideColumns={hideColumns}
          blinkingVisitor= {blinkingVisitor}
        />
      ))}
    </tbody>
  </table>
);

const VisitorRow = ({ name, chatId, visitor, online, servedBy,unseenMsg, viewing, link, copyChatId, onVisitorNameClick, hideColumns ,visitorStatus ,blinkingVisitor}) => 
{
  const [onlineTime, setOnlineTime] = useState('');
  
  
  // Calculate the online time based on the joinTime
  useEffect(() => {
    // Function to calculate time difference
    const calculateOnlineTime = () => {
      const now = new Date();
     
      const diffMs = now - new Date(online); // Difference from the join time
      const diffMins = Math.floor(diffMs / (1000 * 60));
      const diffHrs = Math.floor(diffMins / 60);
      const remainingMins = diffMins % 60;

      setOnlineTime(`${diffHrs > 0 ? diffHrs + 'h ' : ''}${remainingMins}m`);
    };

    // Set an interval to update online time every minute
    const interval = setInterval(() => {
      calculateOnlineTime();
    }, 15 * 1000); // Update every minute (60000 ms)

    // Initial calculation when component mounts
    calculateOnlineTime();

    // Clean up the interval on unmount
    return () => clearInterval(interval);
  }, [online]); // Re-run when joinTime changes

  // Helper to get browser name
  const getBrowserName = (browser) => {
     
    if (browser?.includes("Chrome")) {
      return "chrome";
    } else if (browser?.includes("Firefox")) {
      return "firefox";
    } else if (browser?.includes("Safari") && !browser?.includes("Chrome")) {
      return "safari";
    } else if (browser?.includes("Edge")) {
      return "edge";
    } else if (browser?.includes("Trident")) {
      return "ie";
    }
    return "unknown";
  };
  // Helper to get browser icon as an image
const getBrowserIcon = (browser) => {
  let brows = getBrowserName(browser);
  switch (brows.toLowerCase()) {
    case 'chrome':
      return <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/e/e1/Google_Chrome_icon_%28February_2022%29.svg/480px-Google_Chrome_icon_%28February_2022%29.svg.png" alt="Chrome" className="browser-icon" />;
    case 'firefox':
      return <img src="https://static-00.iconduck.com/assets.00/firefox-icon-1981x2048-4izjijq3.png" alt="Firefox" className="browser-icon" />;
    case 'safari':
      return <img src="https://static-00.iconduck.com/assets.00/safari-icon-2048x2048-ulx2v5ea.png" alt="Safari" className="browser-icon" />;
    case 'edge':
      return <img src="https://static-00.iconduck.com/assets.00/microsoft-edge-icon-2048x2048-c1i8mtto.png" alt="Edge" className="browser-icon" />;
    case 'ie':
      return <img src="https://static-00.iconduck.com/assets.00/internet-explorer-icon-2048x2012-tvwvn67s.png" alt="Internet Explorer" className="browser-icon" />;
    default:
      return null;
  }
};

// Helper to get OS icon as an image
const getOSIcon = (os) => {
  switch (os.toLowerCase()) {
    case 'windows':
      return <img src="https://static-00.iconduck.com/assets.00/windows-icon-2018x2048-0y0cfqbh.png" alt="Windows" className="os-icon" />;
      
    case 'mac':
    case 'macos':
    case 'apple':
      return <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/ab/Icon-Mac.svg/2048px-Icon-Mac.svg.png" alt="Apple" className="os-icon" />;
      
    case 'linux':
      return <img src="https://cdn-icons-png.flaticon.com/512/518/518713.png" alt="Linux" className="os-icon" />;
      
    case 'android':
      return <img src="https://static-00.iconduck.com/assets.00/android-plain-wordmark-icon-256x256-ppoejbtc.png" alt="Android" className="os-icon" />;
      
    case 'ios':
    case 'iphone':
    case 'ipad':
      return <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/a/ab/Icon-Mac.svg/2048px-Icon-Mac.svg.png" alt="iOS" className="os-icon" />;
      
    case 'unix':
      return <img src="https://upload.wikimedia.org/wikipedia/commons/thumb/3/35/Tux.svg/1200px-Tux.svg.png" alt="UNIX" className="os-icon" />;
      
    default:
      return null;
  }
};


// Helper to get country flag as an image
 
const currentVisitorData = blinkingVisitor.find(v => v.client_id === visitor.client_id);
const unseenCount = currentVisitorData ? currentVisitorData.unseenCount : 0;



// Helper to get country flag
const getCountryFlag = (country) => {
  const countryCode = countryNameToCode[country];
  return countryCode ? (
    <img 
      src={`https://flagcdn.com/80x60/${countryCode}.png`} 
      alt={`${country} flag`} 
      width="24" 
      height="18"
    />
  ) : null;
};



  return(

  <tr 
  className={ '  visitor-row-new'} 
  onClick={() => onVisitorNameClick(visitor)}>
    <td>
      <div className={`chat-icon-visitor ${visitorStatus==2?'visitor-idle':''}  ${visitorStatus==5?'visitor-non-active':''}  ${servedBy?.length > 0 ? 'visitor-served' : 'visitor-not-served'}  ${visitorStatus==3?'visitor-close-chat':''} `}>
        { }
        {unseenMsg > 0  &&
        <div className='newMessageNoti'>
         
        {unseenMsg > 0 ? unseenMsg : ''}
        </div>
        }
        <img src="/assets/images/chat-icon.png" alt="Chat Icon" />
      </div>
    </td>
    <td>
      <h4  className='pointer visitor-name'>{name}</h4>
      <div className={`chat-id ${servedBy?.length > 0 ? 'visitor-served' : 'visitor-not-served'}  ${visitorStatus==5?'visitor-non-active':''} ${visitorStatus === 2 ? 'visitor-idle' : ''} ${visitorStatus === 3 ? 'visitor-close-chat' : ''}`}>

        Chat Id: <span className="chatId">{chatId}</span>
        <button onClick={copyChatId}>Copy</button>
      </div>
    </td>
    <td className="browser-info">
  {/* Browser Icon with Tooltip */}
  <div className="tooltip">
    {getBrowserIcon(visitor?.browser)}
    <span className="tooltiptext">
      Browser: {visitor?.browser}
      <div className="tooltip-arrow"></div>
    </span>
  </div>

  {/* OS Icon with Tooltip */}
  <div className="tooltip">
    {getOSIcon(visitor?.os)}
    <span className="tooltiptext">
      OS: {visitor?.os}
      <div className="tooltip-arrow"></div>
    </span>
  </div>

  {/* Country Flag with Tooltip */}
  <div className="tooltip">
    {getCountryFlag(visitor?.country)}
    <span className="tooltiptext">
      Country: {visitor?.country}
      <div className="tooltip-arrow"></div>
    </span>
  </div>
</td>


    <td className={hideColumns ? 'd-none' : ''}>
  {visitorStatus == 1 || 5 ? onlineTime : visitorStatus == 2 ? 'idle' : visitorStatus == 3 ? 'close chat' : ''}
</td>

    <td className={hideColumns ? 'd-none' : ''}>{servedBy}</td>
    <td className={hideColumns ? 'd-none' : ''}>{viewing}</td>
  </tr>
);
}
const calculateOnlineTime = (joinTime) => {
 
 
  
  const now = new Date();
  const diffMs = now - new Date(joinTime);
  const diffMins = Math.floor(diffMs / 60000); // Convert milliseconds to minutes
  const diffHours = Math.floor(diffMins / 60);
  
  if (diffHours > 0) {
    return `${diffHours} hour${diffHours > 1 ? 's' : ''}`;
  } else {
    return `${diffMins} min${diffMins > 1 ? 's' : ''}`;
  }
};
export default Chat;
